#include "MDSF05_SFR.h"
#include "XSFR_GLOBAL.h"
#include "Allhex.h"
/*
Input-only(High impedance) 
	High-Z mode can only be used as input
	
	Open drain output   	
	Open drain mode has good electrical compatibility , external pull-up resistor connected to a 3V power supply can interface with a 3V logic device.
	Suitable for current driven applications, with a relatively strong ability to absorb current (typically within 20mA)
	If this method is not connected to a pull-up resistor, it can output two states: high resistance or low level. As an output, an external pull-up resistor is generally required.

	Quasi-bidirectional 
	The biggest feature of standard bidirectional IO is its input and output functions.
	When the IO output is at a high level, its driving ability is weak, and external loads can easily pull it to a low level.
	When the IO output is low, its driving ability is strong and can absorb a considerable amount of current.
	Standard bidirectional IO has three pull-up transistors: "extremely weak pull-up", "weak pull-up" and "strong pull-up".
	When IO is used as input, it has a Schmidt trigger to suppress input jitter and interference, and the latch must have an input of 1.
	
	
	Push-pull output    	
	The characteristic of push pull output is its strong driving current capability, but push pull mode can only be used in output mode and cannot be used in input mode.
	
	
	//To improve the anti-interference ability of the chip and reduce chip power consumption, please configure all unnecessary GPIO presets as input pull-up in specific projects.
*/
void GPIO_Init (void){
	PINSET1 = PINSET1_REGS;
	PINSET2 = PINSET2_REGS;
	PINSET3 = PINSET3_REGS;
	PINSET4 = PINSET4_REGS;
	PINSET5 = PINSET5_REGS;
	PINSET6 = PINSET6_REGS;
	PINSET7 = PINSET7_REGS;
	
	PINCONG1 = PINCONG1_REGS;
	PINCONG2 = PINCONG2_REGS;
	PINCONG3 = PINCONG3_REGS;
	PINCONG4 = PINCONG4_REGS;
	PINCONG5 = PINCONG5_REGS;
	PINCONG6 = PINCONG6_REGS;
	PINCONG7 = PINCONG7_REGS;
}
